--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------

--List of Return functions to build conditions:
--Return.Time()							returns time of day in seconds
--Return.Day()							returns day of month
--Return.Month()						returns month as number
--Return.Year()							returns year as number
--Return.Mission()						returns campaign mission number
--Return.CampFlag(flag-n)				returns value of campaign flag
--Return.AirUnitActive("UnitName")		returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")		returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")		returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")		returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")		returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")		returns percentage of alive sub elements in target
--Return.GroupHidden("GroupName")		returns group hidden status
--Return.GroupProbability("GroupName")	returns group spawn probability value between 0 and 1

--List of Action functions for trigger actions:
--Action.None()
--Action.Text("your briefing text")
--Action.SetCampFlag(flag-n, boolean/number)
--Action.AddCampFlag(flag-n, number)
--Action.AddImage("filname.jpg")
--Action.CampaignEnd("win"/"draw"/"loss")
--Action.TargetActive("TargetName", boolean)
--Action.AirUnitActive("UnitName", boolean)
--Action.AirUnitBase("UnitName", "BaseName")
--Action.AirUnitPlayer("UnitName", boolean)
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)
--Action.AirUnitRepair()
--Action.AddGroundTargetIntel("sideName")
--Action.GroupHidden("GroupName", boolean)
--Action.GroupProbability("GroupName", number 0-1)

--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			[1] = 'Action.Text("The 1973 Yom Kippur War has been a shock to western air forces. Equipped with the latest generation of Soviet air defense systems, such as highly mobile SA-6 radar guided surface to air missiles, SA-7 shoulder-launched IR-SAMs and ZSU-23-4 Shilka AAA, the Arab armies managed to inflict severe losses to the Israeli Air Force. The IDF/AF lost 102 aircraft in total, 50 of them in the first 3 days of the war, when it was effectively stopped from providing the required air support. With 32 aircraft lost even the West’s latest F-4E Phantom II fighter-bombers proved highly vulnerable. “The wing of the fighter plane was broken by the SAM”, as one Israeli commander put it. Alarmed, the USAF has spent the last 3 years developing new tactics to counter these developments.")',
			[2] = 'Action.Text("The exercise you are about to participate in aims to train F-4E Phantom II crews in Wild Weasel DEAD tactics. For this purpose, 12 F-4E of the 39th Tactical Fighter Training Squadron from George AFB have deployed to Nellis AFB. The Phantoms are tasked with suppressing hostile SAM sites with AGM-45 Shrike anti-radar missiles. Since competent Soviet SAM operators are expected to avoid most anti-radar missiles by temporary ceasing their radar emissions, the SAM sites still need to be destroyed with regular bombs. Nellis’ resident F-5E Tiger II of the 64th Fighter Weapons Squadron will support the training of the Phantom crews by providing the strike-element to the packages. Exact timing and coordination between all elements of the package will be of utmost importance to achieve target destruction and guarantee the safety of involved aircraft, as the time window when SAM sites will be suppressed and helpless is limited.")',
			[3] = 'Action.Text("A formation of 3 simulated SA-6 SAM batteries, supported by short range air defenses and MiG-21 interceptors, has been set up in the Nellis Air Force Range and serves as the primary objective for this exercise. The exercise will last over multiple missions and completes with the destruction of all SA-6 batteries. ")',
			[4] = 'Action.Text("Good luck.")',
		},
	},
	
	
	----- CAMPAIGN END -----
	["Campaign End Victory"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 1',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("With the complete destruction of all designated target SAM sites, this exercise comes to an end. Once again the USAF has proven that the aircraft remains the supreme weapon system. With good training, teamwork and our edge in aerospace technologies, even the latest generation of enemy air defense threats are defeated. The F-4 Phantom II crews of the 38 Tactical Fighter Training Squadron have gained valuable coordinated Wild Weasel experience and will be well prepared to face Soviet SAMs in the battlefields of tomorrow. The F-5E Tiger II pilots of the 64 Fighter Weapons Squadron at Nellis AFB can pride them self with supporting a first class training environment at the Nellis Air Force Range. Rest will be short, as the the next squadron already stands in line to come to Nellis the train with the best. Well done.")',
		},
	},
	["Campaign End Loss"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitReady("64 FWS") < 4',
		action = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("As the number of serviceable aircraft left in the 64 Fighter Weapons Squadron no longer permits further combat operations, this exercise comes to an end. The Air Force leadership is appalled by the poor performance displayed by the participating squadrons. Crews are well advised to contemplate the implications of their inability to overcome the latest generation of Soviet air defense system. Without the ability to defeat the SAM threat, the capability of the USAF to achieving its assigned objectives and playing a decisive role in future wars is seriously jeopardized.")',
		},
	},
	["Campaign End Draw"] = {
		active = true,
		once = true,
		condition = 'MissionInstance == 30',
		action = {
			[1] = 'Action.CampaignEnd("draw")',
			[2] = 'Action.Text("Due to an ongoing period of inactivity in air operations, the exercise has been called off. The results remain indecisive as participating squadrons remain combat capable but have apparently been unable to achieving the assigned objectives.")',
		},
	},
	
	
	----- REPAIR AND REINFORCEMENTS -----
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair("blue")',
	},
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair("red")',
	},
	
	
	---- LOSSES REPORTS ----
	["64 FWS Alive 60%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitReady("64 FWS") < 8',
		action = 'Action.Text("Aircraft strength of the 64th Fighter Weapons Squadron has fallen below 60%.")',
	},
	["64 FWS Alive 50%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitReady("64 FWS") < 6',
		action = 'Action.Text("Aircraft strength of the 64th Fighter Weapons Squadron, has fallen below 50%. The number of available airframes is critically low. The squadron is short of losing all remaining combat capacity.")',
	},
	["39 TFTS Alive 60%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitReady("39 TFTS") < 8',
		action = 'Action.Text("Aircraft strength of the 21st Tactical Fighter Training Squadron has fallen below 60%.")',
	},
	["39 TFTS Alive 50%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitReady("39 TFTS") < 6',
		action = 'Action.Text("Aircraft strength of the 21st Tactical Fighter Training Squadron, has fallen below 50%. The number of available airframes is critically low. The squadron is short of losing all remaining combat capacity.")',
	},
	["963 AWCS Alive 50%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("963 AWCS") == 1',
		action = 'Action.Text("An E-3A Sentry of the 963rd Airborne Warning and Control Squadron has been lost. The loss of this high value asset is a serious setback and puts great strain on the one remaining E-3A. Expect considerable gaps in our airborne early warning.")',
	},
	["963 AWCS Alive 0%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("963 AWCS") == 0',
		action = 'Action.Text("The second E-3A Sentry of the 963rd Airborne Warning and Control Squadron has been lost too. With the destruction of both AWACS, we are left without any airborne early warning.")',
	},

	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
}